<?php
/**
 * Template Name: Tour Grid Contain
 * The main template file for display tour page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

get_header();
?>

<?php
    //Include custom header feature
	get_template_part("/templates/template-header");
?>

<!-- Begin content -->
    
<div class="inner">

	<div class="inner_wrapper">
	
	<div id="page_main_content" class="sidebar_content full_width">
	
	<?php
	    if(empty($term))
	    {
	?>
	    <?php echo tg_apply_content($post->post_content); ?>
	<?php
	    }
	    elseif(!empty($term))
	    { 
	    	$obj_term = get_term_by('slug', $term, 'tourcats');
	?>
	    <?php echo tg_apply_content($obj_term->description); ?>
	<?php
	    }
	?>
	
	<?php
	    //Include custom tour search feature
		get_template_part("/templates/template-tour-search");
	?>
	
	<div id="portfolio_filter_wrapper" class="three_cols gallery section content clearfix">
	<?php
		$key = 0;
		if (have_posts()) : while (have_posts()) : the_post();
			$key++;
			$image_url = '';
			$tour_ID = get_the_ID();
			$image_alt = '';
			global $wpdb;
			$querystr = "SELECT tt.name, ttx.taxonomy from $wpdb->terms as tt join $wpdb->term_relationships as t on tt.term_id = t.term_taxonomy_id join $wpdb->term_taxonomy as ttx on t.term_taxonomy_id = ttx.term_id join $wpdb->posts as p on t.object_id = p.id where p.id=$tour_ID;
			";
	 	$pageposts = $wpdb->get_results($querystr, OBJECT);
		$countries=array();
		$categories=array();
		if(!empty($pageposts))
	 	{
	
	 		foreach($pageposts as $result_item) 
	 		{
	 			$postttt=$result_item;
				if($postttt->taxonomy=='tourcountrs'){
					$countries[]=$postttt->name;
				} else {
					$categories[]=$postttt->name;
				}
			}
		}
			if(has_post_thumbnail($tour_ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($tour_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'full', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, 'gallery_grid', true);
			}
			
			//Get Tour Meta
			$tour_permalink_url = get_permalink($tour_ID);
			$tour_title = get_the_title();
			$tour_country= implode(", ", $countries);
			$tour_category=implode(", ", $categories);

			

			

			
			$last_class = '';
			if(($key)%3==0)
			{
				$last_class = 'last';
			}
	?>
	
	<div class="element portfolio3filter_wrapper">
	
		<div class="one_third gallery3 filterable gallery_type animated<?php echo $key+1; ?>" data-id="post-<?php echo $key+1; ?>">
			<a href="<?php echo $tour_permalink_url; ?>" class="tour-container">
			<?php 
				if(!empty($image_url[0]))
				{
			?>		
        		    <img src="<?php echo $small_image_url[0]; ?>" alt="<?php echo esc_attr($image_alt); ?>" class="tour-img"/>
        		
				
	            <div class="thumb_content">
	                <div class="thumb_title">
						<div class="thumb_header">
							<?php
	                	if(!empty($tour_country))
	                	{
	                	?>
	                	<div class="tour_country">
	                		<?php echo $tour_country; ?>
	                	</div>
	                	<?php
	                	}
	                	?>
						<?php
	                	if(!empty($tour_country))
	                	{
	                	?>
	                	<div class="tour_country">
	                		<?php echo $tour_category; ?>
	                	</div>
	                	<?php
	                	}
	                	?>
						</div>
	                	
				        <h3><?php echo $tour_title; ?></h3>
						
	                </div>
				</div>
			<?php
				}		
			?>	
			</a>
		</div>
	
	</div>
	
	<?php
		endwhile; endif; 
	?>
	</div>
	
	<?php
	    if($wp_query->max_num_pages > 1)
	    {
	    	if (function_exists("wpapi_pagination")) 
	    	{
	?>
			<br class="clear"/>
	<?php
				if(!is_front_page())
			    {
			    	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			    }
			    else
			    {
				    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
			    }
	
	    	    wpapi_pagination($wp_query->max_num_pages);
	    	}
	    	else
	    	{
	    	?>
	    	    <div class="pagination"><p><?php posts_nav_link(' '); ?></p></div>
	    	<?php
	    	}
	    ?>
	    <div class="pagination_detail">
	     	<?php _e( 'Страницы', THEMEDOMAIN ); ?> <?php echo $paged; ?> <?php _e( 'из', THEMEDOMAIN ); ?> <?php echo $wp_query->max_num_pages; ?>
	     </div>
	     <?php
	     }
	?>
	
	</div>
</div>
</div>
</div>
<br class="clear"/><br/>
<?php get_footer(); ?>