<?php
/**
 * The main template file for display single post country.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);

/**
*	Get current page id
**/

if(!isset($current_page_id) && isset($page->ID))
{
    $current_page_id = $page->ID;
}

get_header(); 

//Include custom header feature
get_template_part("/templates/template-header-tour");
?>  
    <div class="inner">

    	<!-- Begid Main content -->
    	<div class="inner_wrapper">
    	
    		<?php
    			//Get Tour Meta
				$tour_booking_url= get_post_meta($current_page_id, 'tour_booking_url', true);
				
				//Get number of your days
				
    		
?>

	    	<div class="sidebar_content full_width">
	    	
		    	<div class="page_content_wrapper">
		    		<?php
						if (have_posts())
						{ 
							while (have_posts()) : the_post();
			
							the_content();
			    		    
			    		    endwhile; 
			    		}
			    	?>
			    	
			    	<?php
			    		//Get Social Share
						get_template_part("/templates/template-share");
			    	?>
		    	</div>
		    	
		    	<?php
		    		//Check if enable comment
		    		$pp_tour_comment = get_option('pp_tour_comment');
		    		
		    		if(!empty($pp_tour_comment))
		    		{
		    	?>
		    	<div class="page_content_wrapper">
		    	<?php
						comments_template( '' );
				?>
		    	</div>
				<?php
		    		}
		    	?>
		    	
		    	<?php
		    		//Get tour gallery
		    		$tour_gallery= get_post_meta($current_page_id, 'tour_gallery', true);
		    		
		    		if(!empty($tour_gallery))
		    		{
		    			$images_arr = get_post_meta($tour_gallery, 'wpsimplegallery_gallery', true);
		    			$pp_lightbox_enable_title = get_option('pp_lightbox_enable_title');
		    	?>
		    	<div id="portfolio_filter_wrapper" class="three_cols gallery tour_single fullwidth section content clearfix">
		    		<?php
		    			foreach($images_arr as $key => $image)
						{
							$image_url = wp_get_attachment_image_src($image, 'original', true);
							$small_image_url = wp_get_attachment_image_src($image, 'gallery_grid', true);
							$image_caption = get_post_field('post_excerpt', $image);
		    		?>
		    			<div class="element portfolio3filter_wrapper">
							<div class="one_third gallery3 filterable gallery_type animated1">
								<a href="<?php echo $image_url[0]; ?>" <?php if(!empty($pp_lightbox_enable_title)) { ?>title="<?php echo esc_attr($image_caption); ?>"<?php } ?> class="fancy-gallery">
				        		    <img src="<?php echo $small_image_url[0]; ?>" alt="" />
				        		</a>
							</div>
		    			</div>
		    		<?php
		    			}
		    		?>
		    	</div>
		    	<?php
		    		}
		    	?>	  
				<?php
		    		$pp_page_bg = '';
		    	    //Get page featured image
				    if(has_post_thumbnail($current_page_id, 'full') && empty($term))
				    {
				        $image_id = get_post_thumbnail_id($current_page_id); 
				        $image_thumb = wp_get_attachment_image_src($image_id, 'full', true);
				        $pp_page_bg = $image_thumb[0];
				    }
				    
				    if(isset($image_thumb[0]))
				    {
					    $background_image = $image_thumb[0];
						$background_image_width = $image_thumb[1];
						$background_image_height = $image_thumb[2];
					}
				    
				    if(!empty($pp_page_bg))
				    {
		    	?>
			    	<div class="tour_call_to_action parallax" <?php if(!empty($pp_page_bg)) { ?>style="background-image:url('<?php echo $pp_page_bg; ?>');"<?php } ?>>
						<div class="parallax_overlay_header tour"></div>
						
						<div class="tour_call_to_action_box">
							<div class="tour_call_to_action_book"><?php _e( "Оформить заявку на расчет", THEMEDOMAIN ); ?></div>
							<a id="call_to_action_tour_book_btn" <?php if(!empty($tour_booking_url)) { ?>href="<?php echo $tour_booking_url; ?>"<?php }?> class="button"><?php echo _e( 'Хочу сюда!', THEMEDOMAIN ); ?></a>
						</div>
			    	</div>
				<?php
	$pp_page_bg = '';
	//Get page featured image
	if(has_post_thumbnail($current_page_id, 'full') && empty($term))
    {
        $image_id = get_post_thumbnail_id($current_page_id); 
        $image_thumb = wp_get_attachment_image_src($image_id, 'full', true);
        $pp_page_bg = $image_thumb[0];
    }
    
    wp_enqueue_script("jquery.validate", get_template_directory_uri()."/js/jquery.validate.js", false, THEMEVERSION, true);
    wp_register_script("script-booking-form", get_template_directory_uri()."/templates/script-booking-form.php", false, THEMEVERSION, true);
	$params = array(
	  'ajaxurl' => admin_url('admin-ajax.php'),
	  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
	);
	wp_localize_script( 'script-booking-form', 'tgAjax', $params );
	wp_enqueue_script("script-booking-form", get_template_directory_uri()."/templates/script-booking-form.php", false, THEMEVERSION, true);
?>
<div id="tour_book_wrapper" class="tour_book_wrapper">
	<div class="tour_book_content">
		<a id="booking_cancel_btn" href="javascript:;"><i class="fa fa-close"></i></a>
		<div class="tour_book_form">
			<div class="tour_book_form_wrapper">
				<h2 class="ppb_title"><?php _e( "Заявка на ", THEMEDOMAIN ); ?><?php echo '"'.get_the_title().'"'; ?></h2>
				<div id="reponse_msg"><ul></ul></div>
				
				<form id="pp_booking_form" method="post" action="/wp-admin/admin-ajax.php">
			    	<input type="hidden" id="action" name="action" value="pp_booking_mailer"/>
			    	<input type="hidden" id="tour_title" name="tour_title" value="<?php echo get_the_title(); ?>"/>
			    	<input type="hidden" id="tour_url" name="tour_url" value="<?php echo get_permalink($current_page_id); ?>"/>
			    	<input type="hidden" id="tour_manager" name="tour_manager" value="<?php echo $tour_manager; ?>"/>
			    	<div class="one_half">
				    	<label for="first_name"><?php echo _e( 'Имя', THEMEDOMAIN ); ?></label>
						<input id="first_name" name="first_name" type="text" class="required_field"/>
			    	</div>
					
					<div class="one_half last">
						<label for="last_name"><?php echo _e( 'Фамилия', THEMEDOMAIN ); ?></label>
						<input id="last_name" name="last_name" type="text" class="required_field"/>
					</div>
					
					<br class="clear"/><br/>
					
					<div class="one_half">
						<label for="email"><?php echo _e( 'Email', THEMEDOMAIN ); ?></label>
						<input id="email" name="email" type="text" class="required_field"/>
					</div>
					
					<div class="one_half last">
						<div class="phone">
							<label for="phone"><?php echo _e( 'Телефон', THEMEDOMAIN ); ?></label>
							<input id="phone" name="phone" type="text"/>
						</div>
						<a class="add-phone">+ Добавить телефон</a>
						<div class="phone2 d-none">
							<label for="phone2"><?php echo _e( 'Дополнительный телефон', THEMEDOMAIN ); ?></label>
							<input id="phone2" name="phone2" type="text"/>
						</div>
					</div>
					
					<br class="clear"/><br/>
					<div class="one">
						<label for="messenger"><?php echo _e( 'Мессенджер', THEMEDOMAIN ); ?></label>
						<div class="mes-container">
					    <div>
							<label for="WhatsApp">WhatsApp</label>
							  <input type="checkbox" id="WhatsApp" name="WhatsApp"
									 >
							  
							</div>

							<div>
								<label for="Viber">Viber</label>
							  <input type="checkbox" id="Viber" name="Viber">
							  
							</div>
						<div>
							<label for="Telegram">Telegram</label>
							  <input type="checkbox" id="Telegram" name="Telegram">
							</div>
					</div>
						</div>
					<div class="one">
						<label for="message"><?php echo _e( 'Дополнительное сообщение', THEMEDOMAIN ); ?></label>
					    <textarea id="message" name="message" rows="7" cols="10"></textarea>
					</div>
					
					<br class="clear"/>
				    
				    <div class="one">
					    <p>
		    				<input id="booking_submit_btn" type="submit" value="<?php echo _e( 'Оформить заявку', THEMEDOMAIN ); ?>"/>
					    </p>
				    </div>
				</form>
			</div>
		</div>
	</div>
</div>
				
				
				
				
		    	<?php
		    		}
		    	?>
				
<div id="page_content_wrapper">
	<h3 class="ttt-title">
		Туры в эту страну
	</h3>
	<div id="portfolio_filter_wrapper" class="three_cols gallery section content clearfix">
	<?php
		global $wpdb;
		$country_title = get_the_title();
		$key = 0;
		$args=array('post_type' => 'tours',
        'order' => 'ASC',
        'suppress_filters' => 0,
        'posts_per_page' => 10,
		'tax_query' => array(array('taxonomy' => 'tourcountrs',
			'field' => 'name',
			'terms' => $country_title,)),	   
				   );
$pageposts1 = new WP_Query($args);
		
	if ( $pageposts1->have_posts() ) { 	
	 while( $pageposts1->have_posts() ){
			$pageposts1->the_post();
			$key++;
			$image_url = '';
			$tour_ID = $post->ID;
			$image_alt = '';
			
			$querystr2 = "SELECT tt.name, ttx.taxonomy from $wpdb->terms as tt join $wpdb->term_relationships as t on tt.term_id = t.term_taxonomy_id join $wpdb->term_taxonomy as ttx on t.term_taxonomy_id = ttx.term_id join $wpdb->posts as p on t.object_id = p.id where p.id=$tour_ID;
			";
	 	$pageposts = $wpdb->get_results($querystr2, OBJECT);
		$countries=array();
		$categories=array();
		if(!empty($pageposts))
	 	{
	
	 		foreach($pageposts as $result_item) 
	 		{
	 			$postttt=$result_item;
				if($postttt->taxonomy=='tourcountrs'){
					$countries[]=$postttt->name;
				} else {
					$categories[]=$postttt->name;
				}
			}
		}
			if(has_post_thumbnail($tour_ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($tour_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'full', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, 'gallery_grid', true);
			}
			
			//Get Tour Meta
			$tour_permalink_url = get_permalink($tour_ID);
			$tour_title = get_the_title($tour_ID);
		 	$tour_manager= get_post_meta($current_page_id, 'tour_manager', true);
			$tour_country= implode(", ", $countries);
			$tour_category=implode(", ", $categories);
			$last_class = '';
			if(($key)%3==0)
			{
				$last_class = 'last';
			}
	?>
	
	<div class="element portfolio3filter_wrapper">
	
		<div class="one_third gallery3 filterable gallery_type animated<?php echo $key+1; ?>" data-id="post-<?php echo $key+1; ?>">
			<a href="<?php echo $tour_permalink_url; ?>" class="tour-container">
			<?php 
				if(!empty($image_url[0]))
				{
			?>		
        		    <img src="<?php echo $small_image_url[0]; ?>" alt="<?php echo esc_attr($image_alt); ?>" class="tour-img"/>
        		
				
	            <div class="thumb_content">
	                <div class="thumb_title">
						<div class="thumb_header">
							<?php
	                	if(!empty($tour_country))
	                	{
	                	?>
	                	<div class="tour_country">
	                		<?php echo $tour_country; ?>
	                	</div>
	                	<?php
	                	}
	                	?>
						<?php
	                	if(!empty($tour_category))
	                	{
	                	?>
	                	<div class="tour_country">
	                		<?php echo $tour_category; ?>
	                	</div>
	                	<?php
	                	}
	                	?>
						</div>
	                	
				        <h3><?php echo $tour_title; ?></h3>
						
	                </div>
				</div>
			<?php
				}		
			?>	
			</a>
		</div>
	
	</div>
	
	<?php
			}}?>
		</div>
<?php	wp_reset_postdata();
		if ( $pageposts1->max_num_pages > 1 ) {
		?>
   		 <script> console.log("dddd"); var this_page = 1; </script>
		 <div class="btn-loadmore button btnbtn" title="Загрузить еще"
	     data-max-pages='<?php echo $pageposts1->max_num_pages; ?>'
         data-param-posts='<?php echo serialize($pageposts1->query_vars); ?>'
         data-tpl="tour">
        <span class="fas fa-redo"></span> Загрузить еще
    </div>
	<?php
		}
	?>
	
	<?php
	    if($wp_query->max_num_pages > 1)
	    {
	    	if (function_exists("wpapi_pagination")) 
	    	{
	?>
			<br class="clear"/>
	<?php
				if(!is_front_page())
			    {
			    	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			    }
			    else
			    {
				    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
			    }
	
	    	    wpapi_pagination($wp_query->max_num_pages);
	    	}
	    	else
	    	{
	    	?>
	    	    <div class="pagination"><p><?php posts_nav_link(' '); ?></p></div>
	    	<?php
	    	}
	    ?>
	    <div class="pagination_detail">
	     	<?php _e( 'Page', THEMEDOMAIN ); ?> <?php echo $paged; ?> <?php _e( 'of', THEMEDOMAIN ); ?> <?php echo $wp_query->max_num_pages; ?>
	     </div>
	     <?php
	     }
	?>
	
	</div>
		    	<?php
		    	$pp_tour_next_prev = get_option('pp_tour_next_prev');
		    	if(!empty($pp_tour_next_prev))
		    	{
				    //Get Previous and Next Post
				    $prev_post = get_previous_post();
				    $next_post = get_next_post();
				?>
				<div class="blog_next_prev_wrapper tour">
				   <div class="post_previous">
				      	<?php
				    	    //Get Previous Post
				    	    if (!empty($prev_post)): 
				    	    	$prev_image_thumb = wp_get_attachment_image_src(get_post_thumbnail_id($prev_post->ID), 'thumbnail', true);
				    	    	if(isset($prev_image_thumb[0]))
				    	    	{
									$image_file_name = basename($prev_image_thumb[0]);
				    	    	}
				    	?>
				      		<span class="post_previous_icon"><i class="fa fa-angle-left"></i></span>
				      		<div class="post_previous_content">
				      			<h6><?php echo _e( 'Предыдущая страна', THEMEDOMAIN ); ?></h6>
				      			<strong><a <?php if(isset($prev_image_thumb[0]) && $image_file_name!='default.png') { ?>class="post_prev_next_link" data-img="<?php echo $prev_image_thumb[0]; ?>"<?php } ?> href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php echo $prev_post->post_title; ?></a></strong>
				      		</div>
				      	<?php endif; ?>
				   </div>
				   <span class="separated"></span>
				   <div class="post_next">
				   		<?php
				    	    //Get Next Post
				    	    if (!empty($next_post)): 
				    	    	$next_image_thumb = wp_get_attachment_image_src(get_post_thumbnail_id($next_post->ID), 'thumbnail', true);
				    	    	if(isset($next_image_thumb[0]))
				    	    	{
									$image_file_name = basename($next_image_thumb[0]);
				    	    	}
				    	?>
				      		<span class="post_next_icon"><i class="fa fa-angle-right"></i></span>
				      		<div class="post_next_content">
				      			<h6><?php echo _e( 'Следующая страна', THEMEDOMAIN ); ?></h6>
				      			<strong><a <?php if(isset($prev_image_thumb[0]) && $image_file_name!='default.png') { ?>class="post_prev_next_link" data-img="<?php echo $next_image_thumb[0]; ?>"<?php } ?> href="<?php echo get_permalink( $next_post->ID ); ?>"><?php echo $next_post->post_title; ?></a></strong>
				      		</div>
				      	<?php endif; ?>
				   </div>
				</div>
				<?php
				}
				?>
		    </div>
		    
    	</div>
    
    </div>
    <!-- End main content -->
   
</div> 

<?php get_footer(); ?>