<?php
/**
 * The main template file for display blog page.
 *
 * @package WordPress
*/

get_header(); 
?>

<br class="clear"/>
<div id="page_caption">
	<div class="page_title_wrapper">
		<h1><?php printf( __( 'Результаты поиска для &quot;%s&quot;', '' ), '' . get_search_query() . '' ); ?></h1>
	</div>
</div>
<br class="clear"/>

<?php
$page_sidebar = 'Search Sidebar';
?>

<!-- Begin content -->

<div id="page_content_wrapper">
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">
    		
    		<div class="sidebar_content full_width nopadding">

    			<div class="sidebar_content">
    			
    			<div class="search_form_wrapper">
	    			<h5><?php _e( 'Новый поиск', THEMEDOMAIN ); ?></h5>
	    			<?php _e( "Если вы не нашли то, что искали, попробуйте новый поиск.", THEMEDOMAIN ); ?><br/><br/>
	    			
	    			<form class="searchform" role="search" method="get" action="<?php echo home_url(); ?>">
						<input style="width:88%" type="text" class="field searchform-s" name="s" value="<?php the_search_query(); ?>" title="<?php _e( 'Введите и нажмите Enter', THEMEDOMAIN ); ?>">
						<button type="submit" id="searchsubmit" class="button submit">
			                <i class="fa fa-search"></i>
			            </button>
					</form>
    			</div>
					
<?php
if (have_posts()) : while (have_posts()) : the_post();
?>

<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post_wrapper">
	    
	    <div class="post_content_wrapper">
	    
			<div class="one">
				<?php
					$post_type = get_post_type();
					$post_type_class = 'fa-file-text-o';
					$post_type_title = '';
					
					switch($post_type)
					{
					    case 'tours':
					    	$post_type_class = 'fa-plane';
					    	$post_type_title = __( 'Tour', THEMEDOMAIN );
					    break;
							
						case 'countries':
							$post_type_class = 'fa-globe';
							$post_type_title = __( 'Country', THEMEDOMAIN );
						break;
					}
				?>
				<div class="post_type_icon">
					<a href="<?php the_permalink(); ?>" title="<?php echo $post_type_title; ?>" class="tooltip">
						<i class="fa <?php echo $post_type_class; ?>"></i>
					</a>
				</div>
			    <div class="post_header">
			    	<h6><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h6>
			    	<div class="post_detail">
					    <?php echo _e( 'Опубликовано', THEMEDOMAIN ); ?>&nbsp;<?php echo get_the_time(THEMEDATEFORMAT); ?>&nbsp;
					    <?php
					    	$author_ID = get_the_author_meta('ID');
					    	$author_name = get_the_author();
					    	$author_url = get_author_posts_url($author_ID);
					    	
					    	if(!empty($author_name))
					    	{
					    ?>
					    	<?php echo _e( 'Автор: ', THEMEDOMAIN ); ?>&nbsp;<a href="<?php echo $author_url; ?>"><?php echo $author_name; ?></a>&nbsp;
					    <?php
					    	}
					    ?>
					    <?php echo _e( 'Имеет', THEMEDOMAIN ); ?>&nbsp;<a href="<?php comments_link(); ?>"><?php comments_number(__('0 комментариев', THEMEDOMAIN), __('1 комментарий', THEMEDOMAIN), __('% Комментариев', THEMEDOMAIN)); ?></a>
					</div>
				    
				    <?php
				    	the_excerpt();
				    ?>
			    </div>
			</div>
	    </div>
	    
	</div>

</div>
<br class="clear"/>
<!-- End each blog post -->

<?php endwhile; endif; ?>

    	<?php
		    if($wp_query->max_num_pages > 1)
		    {
		    	if (function_exists("wpapi_pagination")) 
		    	{
		?>
				<br class="clear"/>
		<?php
		    	    wpapi_pagination($wp_query->max_num_pages);
		    	}
		    	else
		    	{
		    	?>
		    	    <div class="pagination"><p><?php posts_nav_link(' '); ?></p></div>
		    	<?php
		    	}
		    ?>
		    <div class="pagination_detail">
		     	<?php
		     		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		     	?>
		     	<?php _e( 'Страница', THEMEDOMAIN ); ?> <?php echo $paged; ?> <?php _e( 'из', THEMEDOMAIN ); ?> <?php echo $wp_query->max_num_pages; ?>
		     </div>
		     <?php
		     }
		?>
    	
    	<br class="clear"/><br/>	
    	</div>
    	
    		<div class="sidebar_wrapper">
    		
    			<div class="sidebar_top"></div>
    		
    			<div class="sidebar">
    			
    				<div class="content">
    			
    					<ul class="sidebar_widget">
    					<?php dynamic_sidebar($page_sidebar); ?>
    					</ul>
    				
    				</div>
    		
    			</div>
    			<br class="clear"/>
    	
    			<div class="sidebar_bottom"></div>
    		</div>
    	</div>
    	
    </div>
    <!-- End main content -->

</div>  
<br class="clear"/>
<?php get_footer(); ?>